WITH
T_FRAG AS
(
SELECT database_id, object_id, index_id,
       SUM(avg_fragmentation_in_percent * page_count) / Sum(page_count) as POURCENTAGE_DE_FRAGMENTATION
FROM   sys.dm_db_index_physical_stats(DB_ID(), NULL, NULL, NULL, 'DETAILED')
WHERE  index_type_desc IN ('CLUSTERED INDEX', 'NONCLUSTERED INDEX')
  AND  alloc_unit_type_desc='IN_ROW_DATA'
GROUP  BY database_id, object_id, index_id
HAVING SUM(page_count) > 100
   AND SUM(avg_fragmentation_in_percent * page_count) > 0)
SELECT DB_NAME(database_id) + '.' + s.name + '.' + o.name + '.' + i.name as NOM_INDEX, F.POURCENTAGE_DE_FRAGMENTATION
FROM   T_FRAG AS F
       INNER JOIN sys.objects AS o
             ON F.object_id = o.object_id
             INNER JOIN sys.schemas AS s
                   ON o.schema_id = s.schema_id
       INNER JOIN sys.indexes AS i
             ON F.object_id = i.object_id
                AND F.index_id = i.index_id;